<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= esc($title ?? 'Galeri Guru & Staf') ?></title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">

<style>
/* ===================== CSS ASLI ANDA (UTUH) ===================== */
:root{
  --text:#0f172a;
  --muted:#64748b;
  --bg:#ffffff;
  --card:#ffffff;
  --border:#e5e7eb;
  --primary:#2563eb;
  --btnEditBg:#dbeafe;
  --btnEditText:#1d4ed8;
  --btnDelBg:#fee2e2;
  --btnDelText:#b91c1c;
  --shadow:0 10px 25px rgba(15,23,42,.06);
  --radius:16px;
}

*{box-sizing:border-box}
body{
  margin:0;
  background:var(--bg);
  color:var(--text);
  font-family:ui-sans-serif,system-ui,-apple-system,Segoe UI,Roboto,Arial;
}
.wrap{max-width:1180px;margin:28px auto;padding:0 18px}

/* HEADER */
.header{
  display:flex;
  justify-content:space-between;
  align-items:flex-start;
  margin-bottom:18px;
}
.title{margin:0;font-size:34px;font-weight:800}
.subtitle{margin-top:6px;color:var(--muted);font-size:14px}

.btn-primary{
  background:var(--primary);
  color:#fff;
  padding:10px 16px;
  border-radius:999px;
  text-decoration:none;
  font-weight:700;
  font-size:13px;
}

/* CARD */
.card{
  background:var(--card);
  border:1px solid var(--border);
  border-radius:var(--radius);
  box-shadow:var(--shadow);
  overflow:hidden;
}

/* TABLE */
table{
  width:100%;
  border-collapse:collapse;
}
thead th{
  padding:16px 18px;
  font-size:13px;
  font-weight:700;
  border-bottom:1px solid var(--border);
  background:#fff;
  text-align:left;
}
tbody td{
  padding:18px;
  border-bottom:1px solid var(--border);
  vertical-align:middle;
  font-size:14px;
}

/* IDENTITAS */
.identity strong{font-size:15px;display:block}
.identity .nip{margin-top:4px;font-size:13px;color:var(--muted)}
.identity .extra{margin-top:2px;font-size:13px;color:var(--muted);font-style:italic}
.badge-mapel{
  display:inline-block;
  margin-top:6px;
  padding:3px 8px;
  border-radius:999px;
  background:#eef2ff;
  color:#3730a3;
  font-size:12px;
  font-weight:600;
}

/* JABATAN */
.jabatan-utama{text-align:center;font-weight:800}

/* FOTO */
.col-foto{text-align:center}
.foto-wrap{display:flex;justify-content:center}
.thumb{
  width:64px;height:64px;border-radius:12px;
  object-fit:cover;border:1px dashed #cbd5e1;background:#f8fafc;
}

/* AKSI */
.aksi{display:flex;flex-direction:column;align-items:flex-end;gap:8px}
.btn-edit,.btn-del{
  width:74px;padding:8px 0;border-radius:10px;
  text-align:center;font-weight:700;font-size:13px;text-decoration:none;
}
.btn-edit{background:var(--btnEditBg);color:var(--btnEditText)}
.btn-del{background:var(--btnDelBg);color:var(--btnDelText)}

.alert{
  margin-bottom:14px;padding:12px 14px;
  border-radius:12px;border:1px solid #bbf7d0;
  background:#ecfdf5;color:#065f46;
}
.empty{text-align:center;color:var(--muted);padding:26px}

/* ===================== SIDEBAR & RESPONSIVE (TAMBAHAN SAJA) ===================== */
.sidebar{width:280px;min-height:100vh}
.menu-toggle::after{content:'▼';float:right;font-size:12px}
.hamburger{display:none;font-size:1.6rem;color:#fff;cursor:pointer}
.sidebar-overlay{display:none;position:fixed;inset:0;background:rgba(0,0,0,.45);z-index:1040}

@media(max-width:991px){
  .hamburger{display:block}
  .sidebar{
    position:fixed;top:0;left:0;z-index:1050;
    transform:translateX(-100%);transition:.3s;background:#fff
  }
  .sidebar.show{transform:translateX(0)}
  .sidebar-overlay.show{display:block}
}
</style>
</head>

<body class="bg-light">

<nav class="navbar navbar-expand-lg bg-primary navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= site_url('admin') ?>">Welcome back Admin</a>

    <!-- TAMBAHAN: HAMBURGER (TIDAK MENGHAPUS APA PUN) -->
    <span class="hamburger ms-auto me-3" onclick="toggleSidebar()">☰</span>

    <div class="d-flex gap-2 align-items-center">
      <span class="text-white small">Halo, <?= esc(auth()->user()->username ?? 'Admin') ?></span>
      <a class="btn btn-outline-light btn-sm" href="<?= site_url('logout') ?>">Logout</a>
    </div>
  </div>
</nav>

<!-- TAMBAHAN: OVERLAY -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="d-flex">

  <!-- ===== SIDEBAR ASLI KAMU (UTUH, TIDAK DIHAPUS) ===== -->
  <aside class="sidebar bg-white border-end p-3" id="sidebar">
    <div class="fw-bold mb-2">Admin Panel</div>

    <?php
      $uri = service('uri')->getPath();

      $isInfoSekolahActive = ($uri === 'admin' || $uri === 'admin/' ||
                              str_starts_with($uri, 'admin/branding') ||
                              str_starts_with($uri, 'admin/visi-misi') ||
                              str_starts_with($uri, 'admin/kepsek') ||
                              str_starts_with($uri, 'admin/video-profile') ||
                              str_starts_with($uri, 'admin/data-sekolah'));

      $isBeritaActive = (str_starts_with($uri, 'admin/berita') ||
                        str_starts_with($uri, 'admin/pengumuman') ||
                        str_starts_with($uri, 'admin/kelulusan') ||
                        str_starts_with($uri, 'admin/kegiatan') ||
                        str_starts_with($uri, 'admin/prestasi'));

      $isGaleriActive = (str_starts_with($uri, 'admin/galeri') ||
                        str_starts_with($uri, 'admin/guru-staf') ||
                        str_starts_with($uri, 'admin/siswa') ||
                        str_starts_with($uri, 'admin/video') ||
                        str_starts_with($uri, 'admin/ekstrakulikuler'));
    ?>

    <div class="list-group list-group-flush">
      <!-- Informasi Sekolah -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isInfoSekolahActive ? '' : 'collapsed' ?> <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
         data-bs-toggle="collapse"
         href="#infoSekolahMenu"
         role="button"
         aria-expanded="<?= $isInfoSekolahActive ? 'true' : 'false' ?>"
         aria-controls="infoSekolahMenu">
        Informasi Sekolah
      </a>

      <div class="collapse <?= $isInfoSekolahActive ? 'show' : '' ?>" id="infoSekolahMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
             href="<?= site_url('admin') ?>">Dashboard</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/visi-misi') ? 'active' : '' ?>"
             href="<?= site_url('admin/visi-misi') ?>">Visi & Misi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kepsek') ? 'active' : '' ?>"
             href="<?= site_url('admin/kepsek') ?>">Kata Sambutan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video-profile') ? 'active' : '' ?>"
             href="<?= site_url('admin/video-profile') ?>">Video Profile</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/data-sekolah') ? 'active' : '' ?>"
             href="<?= site_url('admin/data-sekolah') ?>">Statistika</a>

             <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/footer') ? 'active' : '' ?>"
             href="<?= site_url('admin/footer') ?>">Footer</a>
        </div>
      </div>

      <!-- Berita -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isBeritaActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#beritaMenu"
         role="button"
         aria-expanded="<?= $isBeritaActive ? 'true' : 'false' ?>"
         aria-controls="beritaMenu">
        Berita
      </a>

      <div class="collapse <?= $isBeritaActive ? 'show' : '' ?>" id="beritaMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/pengumuman') ? 'active' : '' ?>"
             href="<?= site_url('admin/pengumuman') ?>">Pengumuman</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kelulusan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kelulusan') ?>">Pengumuman Kelulusan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kegiatan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kegiatan') ?>">Kegiatan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/prestasi') ? 'active' : '' ?>"
             href="<?= site_url('admin/prestasi') ?>">Prestasi</a>
        </div>
      </div>

      <!-- Galeri -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isGaleriActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#galeriMenu"
         role="button"
         aria-expanded="<?= $isGaleriActive ? 'true' : 'false' ?>"
         aria-controls="galeriMenu">
        Galeri
      </a>

      <div class="collapse <?= $isGaleriActive ? 'show' : '' ?>" id="galeriMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/guru-staf') ? 'active' : '' ?>"
             href="<?= site_url('admin/guru-staf') ?>">Guru dan Staf</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/siswa') ? 'active' : '' ?>"
             href="<?= site_url('admin/siswa') ?>">Siswa/Siswi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video') ? 'active' : '' ?>"
             href="<?= site_url('admin/video') ?>">Video</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/ekstrakurikuler') ? 'active' : '' ?>"
             href="<?= site_url('admin/ekstrakurikuler') ?>">Ekstrakulikuler</a>
        </div>
      </div>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/tentang') ? 'active' : '' ?>"
         href="<?= site_url('admin/tentang') ?>">Tentang</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/password') ? 'active' : '' ?>"
         href="<?= site_url('admin/password') ?>">Ubah Password</a>
    </div>
  </aside>

<!-- ================= KONTEN ASLI ANDA (UTUH) ================= -->
<main class="flex-grow-1">
<div class="wrap">

<div class="header">
  <div>
    <h1 class="title">Galeri Guru & Staf</h1>
    <p class="subtitle">Kelola data guru & staf yang ditampilkan di website.</p>
  </div>
  <a href="<?= base_url('admin/guru-staf/create') ?>" class="btn-primary">+ Tambah Data</a>
</div>

<?php if (!empty($msg)): ?>
  <div class="alert"><?= esc($msg) ?></div>
<?php endif; ?>

<div class="card">
<table>
<thead>
<tr>
  <th>Nama & Identitas</th>
  <th style="text-align:center">Jabatan Utama</th>
  <th style="text-align:center">Urutan</th>
  <th class="col-foto">Foto</th>
  <th style="text-align:right">Aksi</th>
</tr>
</thead>

<tbody>
<?php if (empty($items)): ?>
<tr><td colspan="5" class="empty">Belum ada data.</td></tr>
<?php else: foreach ($items as $it): ?>
<tr>

<td class="identity">
  <strong><?= esc($it['nama']) ?></strong>
  <div class="nip">NIP: <?= esc($it['nip'] ?? '-') ?></div>

  <?php if (!empty($it['jabatan_tambahan'])): ?>
    <div class="extra"><?= esc($it['jabatan_tambahan']) ?></div>
  <?php endif; ?>

  <?php if (!empty($it['mapel'])): ?>
    <div class="badge-mapel">Mapel: <?= esc($it['mapel']) ?></div>
  <?php endif; ?>
</td>

<td class="jabatan-utama"><?= esc($it['jabatan_utama'] ?? '-') ?></td>
<td style="text-align:center;color:var(--muted)"><?= esc($it['urutan']) ?></td>

<td class="col-foto">
  <div class="foto-wrap">
    <?php if (!empty($it['foto'])): ?>
      <img class="thumb" src="<?= base_url('uploads/guru-staf/'.$it['foto']) ?>">
    <?php else: ?>
      <div class="thumb" style="opacity:.3"></div>
    <?php endif; ?>
  </div>
</td>

<td>
  <div class="aksi">
    <a class="btn-edit" href="<?= base_url('admin/guru-staf/edit/'.$it['id']) ?>">Edit</a>
    <a class="btn-del" href="<?= base_url('admin/guru-staf/delete/'.$it['id']) ?>"
       onclick="return confirm('Yakin hapus data ini?')">Hapus</a>
  </div>
</td>

</tr>
<?php endforeach; endif; ?>
</tbody>
</table>
</div>

</div>
</main>
</div>

<script>
function toggleSidebar(){
  document.getElementById('sidebar').classList.toggle('show');
  document.querySelector('.sidebar-overlay').classList.toggle('show');
}
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
